// RFID.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
//#include "windows.h"
#include "atlbase.h"
#include <string.h>
#include <stdio.h>
#include <time.h>
#include "RFID.h"
//#include <winsock2.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



#define OK					0
#define FAIL				-1
#define STX					0XAA
#define ETX					0XBB

#define MaxPage				12
#define MaxAddress			255		//API max address define
#define MaxTime				1		//Retry to send out data times when not reply
#define WaitReceive 		2000	//After transmit waitting receiver frist data
#define WaitAuthen  		400		//After transmit waitting receiver frist data
#define MaxBufferSize		1024


/***************************************************** Command define content *********************************************************/

//Define ISO14443 TypeA Command
#define CMD_MF_Request						0x03	//Requst card  REQA
#define CMD_MF_Anticoll						0x04	//Anticollision
#define CMD_MF_Select						0x05	//To select card
#define CMD_MF_Halt							0x06	//To halt card

//Define ISO14443 TypeB Command
#define CMD_RequestB						0x09
#define CMD_AnticollB						0x0A
#define CMD_AttribB							0x0B
#define CMD_Rst_TypeB						0x0C
#define CMD_TransCmdB						0x0D

          
//Define ISO15693(13.56kHz) Command
#define CMD_ISO15693_Inventory				0x10
#define CMD_ISO15693_Read					0x11
#define CMD_ISO15693_Write					0x12
#define CMD_ISO15693_Lock					0x13
#define CMD_ISO15693_StayQuiet				0x14
#define CMD_ISO15693_Select					0x15
#define CMD_ISO15693_Resettoready			0x16
#define CMD_ISO15693_WriteAfi				0x17
#define CMD_ISO15693_LockAfi				0x18
#define CMD_ISO15693_WriteDsfid				0x19
#define CMD_ISO15693_LockDsfid				0x1A
#define CMD_ISO15693_GetSysInfo				0x1B
#define CMD_ISO15693_GetMulSecurity			0x1C
#define CMD_ISO15693_TransferCMD			0x1D


//Define Mifare Applcation Command
#define CMD_MF_Read							0x20
#define CMD_MF_Write						0x21
#define CMD_MF_InitVal						0x22
#define CMD_MF_Dec							0x23
#define CMD_MF_Inc							0x24
#define CMD_MF_GET_SNR						0x25
//#define  CMD_MF_Value						0x26
#define CMD_MF_PowerOn						0x27	//CPU Card Command
#define CMD_MF_Transfer						0x28	//CPU Card Command
#define CMD_MF_RST_Antenna					0x29	//CPU Card Command


//Ultra Light Card Command
#define CMD_UL_Request						CMD_MF_Request
#define CMD_UL_Read							CMD_MF_Read
#define CMD_UL_Write						CMD_MF_Write


//Define System Commands
#define CMD_SetAddress     					0x80	//Set reader address
#define CMD_SetBaudrate    					0x81	//Set reader baudrate
#define CMD_SetSerialNum   					0x82	//Set reader serial number
#define CMD_GetSerialNum   					0x83	//Get reader serial number
#define CMD_Write_User_Info					0x84	//Set User Information
#define CMD_Read_User_Info					0x85	//Get User Information
#define CMD_GetVersionNum  					0x86	//Get reader version number
#define CMD_ControlLED						0x88       
#define CMD_ControlBuzzer					0x89
#define CMD_ControlRelay					0x8E


/******************************************************* End Command Define ***********************************************************/




static void CheckControlCode(unsigned char Value);
static int	StartTransmit(int DeviceAddress);
static void TransmitData(void);
static int	GetRecData(int Tick);
static int	CheckAddress(void);

/******************************************************** Global Variable *************************************************************/

static SOCKET			hComm = INVALID_SOCKET;
static unsigned char	inBuffer[1024];
static unsigned char	outBuffer[1024];
static unsigned char	CheckSum;
static DWORD			nBytesWrite;
static int				TimeCount;


/*
// ں
BOOL APIENTRY DllMain( SOCKET hModule, 
                       DWORD  ul_Reason_Call,
                       LPVOID lpReserved)
{
    switch (ul_Reason_Call)
	{
		case DLL_PROCESS_ATTACH:
			printf("\nProcess Attach of dll");
		    break;
		case DLL_THREAD_ATTACH:
			printf("\nThread Attach of dll");
		break;
		case DLL_THREAD_DETACH:
			printf("\nThread Detach of dll");
		break;

		case DLL_PROCESS_DETACH:
			printf("\nProcess Detach of dll");
			break;
    }
    return TRUE;
}
*/

/***************************************************** Global Function *****************************************************************/

static void CheckControlCode(unsigned char Value)
{
	outBuffer[nBytesWrite] = Value;
	CheckSum ^= Value;
	nBytesWrite++;
}

static int StartTransmit(int DeviceAddress)
{
	if (hComm != INVALID_SOCKET) {
     	outBuffer[0] = STX;
		nBytesWrite = 1;
		CheckSum = 0x00;
		CheckControlCode(DeviceAddress & 0xff);
		return(0);
	}
	return(-1);
}

void TransmitData(void) //УλֹͣλBufferУٷBufferе
{
	CheckControlCode(CheckSum);
	outBuffer[nBytesWrite] = ETX;
	++nBytesWrite;

	//PurgeComm(hComm, PURGE_TXCLEAR|PURGE_RXCLEAR|PURGE_TXABORT|PURGE_RXABORT);
	//WriteFile(hComm, outBuffer, nBytesWrite, &nBytesWrite, NULL);
	send(hComm, (char *)outBuffer, nBytesWrite, 0);
}

int GetRecData(int Tick)
{
	int			i;
	int			nBytesRead;
	fd_set		RdSet;
	timeval		timeout = {Tick / 1000, Tick % 1000}; 

	FD_ZERO(&RdSet);
	FD_SET(hComm, &RdSet);
	
	int res = select(0, &RdSet, NULL, NULL, &timeout);
	if (res == 0 || res == -1) {
		return 4;
	}
	else if (FD_ISSET(hComm, &RdSet)) {
		nBytesRead = recv(hComm, (char *)inBuffer, sizeof(inBuffer), 0);
		for (i = 1; i < nBytesRead - 1; i++)
			inBuffer[0] ^= inBuffer[i];
		inBuffer[0] ^= STX;
		
		if (inBuffer[0] == 0) //УǷȫ
			return (0);
		else
			return (1);
	}

	return (4);
}

int CheckAddress(void) //ַУ
{
    unsigned char address = 1;

    if(inBuffer[1] != outBuffer[address])
		return(1);
    else
		return(0);
}



/*
 ***************************************************************************************************************************************
 **************************************************** API Function Definition **********************************************************
 ***************************************************************************************************************************************
 */

/*
 * APIЭ: AA DeviceAddress DataLength(CMD+ParamData) CMD ParamData CRC BB
 *
 * int DeviceAddress  ǰ豸ַ   
 * int num_blk            
 * int num_length     ݳ
 * char *user_info    û
 *
 * أ
 *	0  success
 *	1 the parameter value out of range
 *	2 checksum error.
 *	3 Not selected COM port
 *  4 time out reply
 *  5 check sequence error
 *  7 check sum error
 */

/**************************************************** API System Function *************************************************************/

extern "C" SOCKET RFID_API API_OpenClientSocket(unsigned char *ip, unsigned int port)
{
	WORD	wVersionRequested;
	WSADATA wsaData;
	CString strTmp;
	int		err;

	//׽ֿ
	wVersionRequested = MAKEWORD(2, 2);
	err = WSAStartup(wVersionRequested, &wsaData);
	if (err != 0) {
		return INVALID_SOCKET;
	}
	
	if ( (LOBYTE(wsaData.wVersion) != 2) || (HIBYTE(wsaData.wVersion) != 2)) {
		WSACleanup();
		return INVALID_SOCKET;
	}

	//ӵ׽
	SOCKET s = socket(AF_INET, SOCK_STREAM, 0);
	if (s == INVALID_SOCKET) {
		return s;
	}

	SOCKADDR_IN addrDevice;
	strTmp.Format("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]);
	addrDevice.sin_addr.S_un.S_addr = inet_addr(strTmp);
	addrDevice.sin_family = AF_INET;
	addrDevice.sin_port = htons(port);

	int c = connect(s, (SOCKADDR *)&addrDevice, sizeof(SOCKADDR));
	if (c != 0) {
		closesocket(s);
		WSACleanup();
		s = INVALID_SOCKET;
		return s;
	}
	
	return s;
}

extern "C" SOCKET RFID_API API_OpenServerSocket(unsigned int port)
{
	WORD	wVersionRequested;
	WSADATA wsaData;
	CString strTmp;
	int		err;
	
	//׽ֿ
	wVersionRequested = MAKEWORD(2, 2);
	err = WSAStartup(wVersionRequested, &wsaData);
	if (err != 0) {
		return INVALID_SOCKET;
	}
	
	if ( (LOBYTE(wsaData.wVersion) != 2) || (HIBYTE(wsaData.wVersion) != 2)) {
		WSACleanup();
		return INVALID_SOCKET;
	}
	
	//ڼ׽
	SOCKET sockSrv = socket(AF_INET,SOCK_STREAM,0);
	if (sockSrv == INVALID_SOCKET) {
		return sockSrv;
	}
	
	SOCKADDR_IN addrSrv;
	addrSrv.sin_addr.S_un.S_addr = htonl(INADDR_ANY);
	addrSrv.sin_family = AF_INET;
	addrSrv.sin_port = htons(port);
	
	int ret = bind(sockSrv, (sockaddr*)&addrSrv, sizeof(SOCKADDR));
	if (ret != 0) {
		closesocket(sockSrv);
		WSACleanup();
		sockSrv = INVALID_SOCKET;
		return sockSrv;
	}
	
	ret = listen(sockSrv, SOMAXCONN);
	if (ret != 0) {
		closesocket(sockSrv);
		WSACleanup();
		sockSrv = INVALID_SOCKET;
		return sockSrv;
	}
	
	return sockSrv;
}

extern "C" SOCKET RFID_API API_OpenUDPServerSocket(unsigned int port)
{
	WORD	wVersionRequested;
	WSADATA wsaData;
	int		err;
	
	//׽ֿ
	wVersionRequested = MAKEWORD(2, 2);
	err = WSAStartup(wVersionRequested, &wsaData);
	if (err != 0) {
		return INVALID_SOCKET;
	}
	
	if ( (LOBYTE(wsaData.wVersion) != 2) || (HIBYTE(wsaData.wVersion) != 2)) {
		WSACleanup();
		return INVALID_SOCKET;
	}
	
	//ڼ׽
	SOCKET sockSrv = socket(AF_INET, SOCK_DGRAM, 0);
	if (sockSrv == INVALID_SOCKET) {
		return sockSrv;
	}
	
	SOCKADDR_IN addrSrv;
	addrSrv.sin_addr.S_un.S_addr = htonl(INADDR_ANY);
	addrSrv.sin_family = AF_INET;
	addrSrv.sin_port = htons(port);

	int ret = bind(sockSrv, (SOCKADDR *)&addrSrv, sizeof(SOCKADDR));
	if (ret != 0) {
		closesocket(sockSrv);
		WSACleanup();
		sockSrv = INVALID_SOCKET;
		return sockSrv;
	}

	return sockSrv;
}

extern "C" int RFID_API API_CloseSocket(SOCKET s)
{
	if (s == NULL) {
		return 1;
	}
	closesocket(s);
	WSACleanup();
	s = INVALID_SOCKET;
	return 0;
}


// 1.API_SetDeviceAddress
extern "C" int RFID_API API_SetDeviceAddress(SOCKET commHandle, int DeviceAddress, unsigned char NewAddress, unsigned char *Buffer)
{
    if (DeviceAddress > MaxAddress )
		return(10);

    hComm = commHandle;

    for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x02);
			CheckControlCode(CMD_SetAddress);
			CheckControlCode(NewAddress);

			TransmitData();
			switch (GetRecData(WaitReceive+10)) {
			case 0:
				Buffer[0] = inBuffer[4]; //return address
				return(inBuffer[3]);     //status return
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

// 2.API_SetBaudrate
extern "C" int RFID_API API_SetBaudrate(SOCKET commHandle, int DeviceAddress, unsigned char NewBaud, unsigned char *Buffer)
{	
    if (DeviceAddress > MaxAddress )
		return(10);
	
    hComm = commHandle;

    for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x02);
			CheckControlCode(CMD_SetBaudrate);
			CheckControlCode(NewBaud);

			TransmitData();
			switch (GetRecData(WaitReceive+10)) {
			case 0: //check sum success
				if(!CheckAddress()) {
					Buffer[0] = inBuffer[4];
					return(inBuffer[3]); //status return
				}
				else 
					return(5);
				case 1: //check sum error
					return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

// 3.API_SetSerNum
extern "C" int RFID_API API_SetSerNum(SOCKET commHandle, int DeviceAddress, unsigned char *NewValue, unsigned char *Buffer)
{
   	if (DeviceAddress > MaxAddress )
		return(10);

	hComm = commHandle;

    for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x09);
			CheckControlCode(CMD_SetSerialNum);
			for (int n = 0; n < 8; n ++) //8ֽڵĶдк
				CheckControlCode(NewValue[n]);

			TransmitData();
			switch (GetRecData(WaitReceive+10)) {
			case 0: //check sum success
				if (!CheckAddress()) {
					Buffer[0] = inBuffer[4];    //return DATA[0]
					return(inBuffer[3]);        //status return
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

// 4.API_GetSerNum
extern "C" int RFID_API API_GetSerNum(SOCKET commHandle, int DeviceAddress, unsigned char *Buffer)
{
   	if (DeviceAddress > MaxAddress )
		return(10);

    hComm = commHandle;

    for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x01);
			CheckControlCode(CMD_GetSerialNum);

			TransmitData();
			switch(GetRecData(WaitReceive+10)) {
			case 0: { //check sum success
				Buffer[0] = inBuffer[2] -1;
				memcpy(&Buffer[1], &inBuffer[4], Buffer[0]); //return SerialNum
				return(inBuffer[3]);
			}
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

/*
// 5.API_WriteUserInfo
extern "C" int RFID_API API_WriteUserInfo(SOCKET commHandle, int DeviceAddress, int num_blk, int num_length, char *user_info)
{
    if (DeviceAddress > MaxAddress )
		return(10);
	
    hComm = commHandle;

	for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(num_length+3);
			CheckControlCode(CMD_Write_User_Info);
			CheckControlCode(num_blk);     //
			CheckControlCode(num_length);  //ݳ
			for (int i = 0; i < num_length; i++) {
				CheckControlCode(*(user_info++));
			}
			user_info -= num_length;

			TransmitData();
			switch (GetRecData(WaitReceive + 100)) {
			case 0: //check sum success
				if(!CheckAddress())
					return(inBuffer[3]);
				else 
					return(5);
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

// 6.API_ReadUserInfo
extern "C" int RFID_API API_ReadUserInfo(SOCKET commHandle, int DeviceAddress, int num_blk, int num_length, char *user_info)
{
	if (DeviceAddress > MaxAddress )
		return(10);
	
    hComm = commHandle;

	for(TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x03);
      	    CheckControlCode(CMD_Read_User_Info);
            CheckControlCode(num_blk);    //
            CheckControlCode(num_length); //ݳ

      		TransmitData();
      		switch (GetRecData(WaitReceive * 2)) {
       		case 0: //check sum success
				if (!CheckAddress()) {
            		for (int i = 0; i < num_length; i++) {
              			*user_info = inBuffer[4+i];
              			user_info++;
             		}
            		return(inBuffer[3]);
           		}
          		else 
					return(5);
       		case 1: //check sum error
         		return(7);
      		}
		}
		else 
			return(3);
	}
	return(4);
}
*/

// 7.API_GetVersionNum
extern "C" int RFID_API API_GetVersionNum(SOCKET commHandle, int DeviceAddress, char *VersionNum)
{
	if (DeviceAddress > MaxAddress )
		return(10);

	hComm = commHandle;

	// delay()
	TimeCount = GetTickCount();
	for (int timeout = TimeCount + 200; TimeCount < timeout; )
		TimeCount = GetTickCount();
	
	for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x01);
			CheckControlCode(CMD_GetVersionNum);

			TransmitData();
			switch (GetRecData(WaitReceive)) {
			case 0: //check sum success
				if(!CheckAddress()) {
					if (inBuffer[3] == OK) {
						memcpy(VersionNum, &inBuffer[4], inBuffer[2] -1); //nBytesRead
					}
					return(inBuffer[3]);
				}
				else 
					return(5);			
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

// 8. API_ControlLED()
// lednum: Red/Green LED  freq 1ӵʱ䣬λ20  duration 
extern "C" int RFID_API API_ControlLED(SOCKET commHandle, int DeviceAddress, unsigned char freq, unsigned char duration, unsigned char *Buffer)
{
    if(DeviceAddress > MaxAddress )
		return(10);

    hComm = commHandle;

    for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			if (*Buffer == 00)
				CheckControlCode(0x03);
			else
				CheckControlCode(0x04);
			CheckControlCode(CMD_ControlLED);
			if (!(*Buffer == 00))
				CheckControlCode(*Buffer -1);
			CheckControlCode(freq);
			CheckControlCode(duration);

			TransmitData();
			switch (GetRecData(WaitReceive+10)) {
			case 0: //check sum success
				if (!CheckAddress()) {
					Buffer[0] = inBuffer[4];
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

// 9.API_ControlBuzzer
// freq   duration 
extern "C" int RFID_API API_ControlBuzzer(SOCKET commHandle, int DeviceAddress, unsigned char freq, unsigned char duration, unsigned char *Buffer)
{
   	if (DeviceAddress > MaxAddress )
		return(10);

    hComm = commHandle;

    if (DeviceAddress > MaxAddress )
		return(10);

    for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x03);
			CheckControlCode(CMD_ControlBuzzer);
			CheckControlCode(freq);
			CheckControlCode(duration);

			TransmitData();
			switch (GetRecData(WaitReceive+10)) {
			case 0:  //check sum success
				if(!CheckAddress()) {
					Buffer[0] = inBuffer[4];
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

// 10.API_ControlRelay
// flag: ON/OFF
extern "C" int RFID_API API_ControlRelay(SOCKET commHandle, int DeviceAddress, unsigned char flag, unsigned char *Buffer)
{
   	if (DeviceAddress > MaxAddress)
		return(10);
	
    hComm = commHandle;
	
    if (DeviceAddress > MaxAddress)
		return(10);
	
    for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x02);
			CheckControlCode(CMD_ControlRelay);
			CheckControlCode(flag);
			
			TransmitData();
			switch (GetRecData(WaitReceive+10)) {
			case 0:  //check sum success
				if(!CheckAddress()) {
					Buffer[0] = inBuffer[4];
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

/************************************************** API ISO14443 TypeA Function *********************************************************/

// 1.API_MF_Request()
extern "C" int RFID_API API_MF_Request(SOCKET commHandle, int DeviceAddress, unsigned char inf_mode, unsigned char *Buffer)
{
	if (DeviceAddress > MaxAddress) 
		return(10);
	
    hComm = commHandle;
		   
	for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x02);
			CheckControlCode(CMD_MF_Request);
			CheckControlCode(inf_mode);

			TransmitData();

			switch (GetRecData(WaitReceive)) {
			case 0:  //check sum success
				if(CheckAddress() == 0x00) {
					if(inBuffer[3] == OK) {				
						Buffer[1] = inBuffer[5];
					}
					Buffer[0] = inBuffer[4];
					return(inBuffer[3]);
				}
				else 
					return(5);	
			case 1: //check sum error
				return(7);
			 }
		}
		else 
			return(3);
	}
	return(4);
}

// 2.API_MF_Anticoll()
extern "C" int RFID_API API_MF_Anticoll(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char *Buffer)
{
	if (DeviceAddress > MaxAddress)
		return(10);

    hComm = commHandle;

	for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if(!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x02);
			CheckControlCode(CMD_MF_Anticoll);
			CheckControlCode(mode);
			TransmitData();
			
			switch(GetRecData(WaitReceive)) {
			case 0: //check sum success
				if(!CheckAddress()) {
					Buffer[0] = inBuffer[4];
					if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					}
					return (inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch
		} // End of if
		else
			return(3);
	}
	return(4);
}

// 3.API_MF_Select()
extern "C" int RFID_API API_MF_Select(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char UIDLen, unsigned char *uid, unsigned char *Buffer)
{
	if(DeviceAddress > MaxAddress )
		return(10);
	
    hComm = commHandle;

	for ( TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(UIDLen + 0x02);
			CheckControlCode(CMD_MF_Select);
			CheckControlCode(mode);
			
			if (UIDLen == 4) {
				for (int i = 0; i < 4;i++) //4λĴ
					CheckControlCode(uid[i]);
			}
			else if (UIDLen == 7) {
				for (int i = 0; i < 7;i++) //7λĴ
					CheckControlCode(uid[i]);
			}

			TransmitData();

			switch(GetRecData(WaitReceive)) {
			case 0:  //check sum success
				if (CheckAddress() == 0x00) {
					Buffer[0] = inBuffer[4];
					if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					}
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

// 4.API_MF_Halt()
extern "C" int RFID_API API_MF_Halt(SOCKET commHandle, int DeviceAddress)
{
	if (DeviceAddress > MaxAddress)
		return(10);
	
    hComm = commHandle;
	
	for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x01);
			CheckControlCode(CMD_MF_Halt);

			TransmitData();

			switch (GetRecData(WaitAuthen)) {
			case 0:  //check sum success
				if (!CheckAddress()) {
					return(inBuffer[3]);
				}
				else
					return(5);
			case 1: //check sum error
				return(7);
			}
		} //end of start transmit data to device
		else
			return(3);
	}
	return(4);
}


/************************************************** API ISO14443 TypeB Function *********************************************************/

// 1.API_RequestType_B()
extern "C" int RFID_API API_Request_B(SOCKET commHandle, int DeviceAddress, unsigned char *Buffer)
{
	if (DeviceAddress > MaxAddress)
		return(10);
	
	hComm = commHandle;

	for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x01);
			CheckControlCode(CMD_RequestB);

			TransmitData();

			switch(GetRecData(WaitReceive)) {
			case 0: //check sum success
				if (CheckAddress()==0x00) {
	    			if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
	    				memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					}
					else {
		   				*Buffer = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else
					return(5);
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

// 2.API_AntiType_B()
extern "C" int RFID_API API_Anticoll_B(SOCKET commHandle, int DeviceAddress, unsigned char *Buffer)
{
	if (DeviceAddress > MaxAddress)
		return(10);

	hComm = commHandle;
	
	for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if(!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x01);
			CheckControlCode(CMD_AnticollB);

			TransmitData();
			
			switch (GetRecData(WaitReceive)) {
			case 0: //check sum success       
				if (!CheckAddress()) {
	    			if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					}
					else {
		   				*Buffer = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
					return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}

// 3.API_SelectType_B()
extern "C" int RFID_API API_Attrib_B(SOCKET commHandle, int DeviceAddress, unsigned char *SerialNum, unsigned char *Buffer)
{
	if (DeviceAddress > MaxAddress)
		return(10);
		
	hComm = commHandle;

	for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x05);
			CheckControlCode(CMD_AttribB);
			for(int i = 0; i < 4; i++)
				CheckControlCode(SerialNum[i]);   //к

			TransmitData();
	
			switch (GetRecData(WaitReceive)) {
			case 0: //check sum success
				if (!CheckAddress()) {
					Buffer[0] = inBuffer[4];
					return(inBuffer[3]);
				}
				else
					return(5);
			case 1: //check sum error
				return(7);
			}
		}
		else  
			return(3);
	}
	return(4);
}


// 4.API_RST_B()
extern "C" int RFID_API API_RESET_B(SOCKET commHandle, int DeviceAddress, unsigned char *Buffer)
{
	if (DeviceAddress > MaxAddress)
		return(10);

	hComm = commHandle;

	for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x01);
			CheckControlCode(CMD_Rst_TypeB);

			TransmitData();
			
			switch (GetRecData(WaitReceive)) {
			case 0: //check sum success  
				if(!CheckAddress()) {
           			if(inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
           			}
					else {
		   				Buffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch
		}
		else
			return(3);
	}
	return(4);
}

// 5.API_ISO14443TypeBTransCmd()
extern "C" int RFID_API API_TransferCMD_B(SOCKET commHandle, int DeviceAddress, unsigned char cmdSize, unsigned char *cmd, unsigned char *Buffer)
{
    if (DeviceAddress > MaxAddress) 
		return(10);

    hComm = commHandle;

    for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
        if (!StartTransmit(DeviceAddress)) {
            CheckControlCode(cmdSize + 0x02);
            CheckControlCode(CMD_TransCmdB);
            CheckControlCode(cmdSize);
            for (int n = 0; n < cmdSize; n ++) {
                CheckControlCode(cmd[n]);
            }

			TransmitData();

			switch (GetRecData(WaitReceive)) {
			case 0:  //check sum success
				if (!CheckAddress()) {
					if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					}
					else {
						Buffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch
		}
		else 
			return(3);
	}
	return(4);
}


/******************************************************* API ISO15693 Function *********************************************************/

// 1.API_ISO15693_Inventory()
extern "C" int RFID_API API_ISO15693_Inventory(	SOCKET commHandle, int deviceAddress, unsigned char flag, 
												unsigned char afi, unsigned char datalen, const unsigned char *pData,
												unsigned char *pBuffer)
{
    if (deviceAddress > MaxAddress)
		return(10);

    hComm = commHandle;

    for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
        if(!StartTransmit(deviceAddress)) {
            CheckControlCode(0x04+ datalen);
            CheckControlCode(CMD_ISO15693_Inventory); 
			CheckControlCode(flag);				//FLAG
            CheckControlCode(afi);				//AFI, ǳȣΪһֽ
            CheckControlCode(datalen);
            for (int n = 0; n < datalen; n++)	//;
                CheckControlCode(pData[n]);

            TransmitData();

            switch(GetRecData(WaitReceive)) {
			case 0:  //check sum success
				if (!CheckAddress()) {
					if (inBuffer[3] == OK) {
						pBuffer[0] = inBuffer[2] -1;
						memcpy(&pBuffer[1], &inBuffer[4], pBuffer[0]);
                    }
					else {
						pBuffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
        else 
			return(3);
	}
	return(4);
}

// 2.API_ISO15693_Read()
extern "C" int RFID_API API_ISO15693_Read(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
											unsigned char blk_add, unsigned char num_blk,
                                            unsigned char *uid, unsigned char *buffer)
{
    int	Retry, StartCnt;

	if (DeviceAddress > MaxAddress)
		return (10);       
	if (num_blk <= 0) 
		return (1);
        
	hComm = commHandle;

	for ( Retry = 0; Retry < MaxTime; Retry++) {
		if (!StartTransmit(DeviceAddress)) {
			if (flags == 0x22) { 
				CheckControlCode(0x0C);
			} //DATALENGTH
			else { 
				CheckControlCode(0x04); 
			} //DATALENGTH

      		CheckControlCode(CMD_ISO15693_Read);	//CMD
			CheckControlCode(flags);				//Flag ֵ
			CheckControlCode(blk_add);				//ʼ
			CheckControlCode(num_blk);				//
			if (flags == 0x22)						//flags	0x02 uid
			{										//		0x22 uid
				for (int n = 0; n < 8; n ++)        //      0x42 uidҪȫλ
					CheckControlCode(uid[n]);
			}

      		TransmitData();
   			StartCnt = (WaitReceive + (num_blk >>4)*WaitReceive + 30);

			switch(GetRecData(StartCnt)) {
			case 0: //check sum success
				if(CheckAddress()==0x00) {
					if(inBuffer[3] == OK) {
						buffer[0] = inBuffer[2] -1;
						memcpy(&buffer[1], &inBuffer[4], buffer[0]);
					}
					else {
						buffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
		else 
			return(3);
	}
	return(4);
}

// 3.API_ISO15693_Write()
extern "C" int RFID_API API_ISO15693_Write(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
                                            unsigned char blk_add, unsigned char num_blk,
                                            unsigned char *uid, unsigned char *data)
{
    int Retry, StartCnt, n;

	if (DeviceAddress > MaxAddress)
		return(10);   
	if (num_blk <= 0)
		return (1);
    
	hComm = commHandle;

	for (Retry = 0; Retry < MaxTime; Retry++) {
		if (!StartTransmit(DeviceAddress)) {
			if(flags == 0x22) { 
				CheckControlCode(num_blk*4 +12);
			} //DATALENGTH
			else { 
				CheckControlCode(num_blk*4 +4); 
			} //DATALENGTH
      		CheckControlCode(CMD_ISO15693_Write);   //CMD
			CheckControlCode(flags);				//flags
			CheckControlCode(blk_add);				//Ҫдʼ
			CheckControlCode(num_blk);				//дĿ

			if (flags == 0x22) {
				for (n = 0; n < 8; n++)				//UID
					CheckControlCode(uid[n]);
			}
			for (n = 0; n < num_blk*4; n++)
				CheckControlCode(data[n]);

      		TransmitData();
   			StartCnt = (WaitReceive + (num_blk >>2)*WaitReceive + 30);
	
			switch (GetRecData(StartCnt)) {
			case 0:  //check sum success
				data[0] = inBuffer[4];
				if (CheckAddress() == 0x00) {
					return(inBuffer[3]);
				}
				return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
		else 
			return(3);
	}
	return(4);
}

// 4.API_ISO15693_Lock()
extern "C" int RFID_API API_ISO15693_Lock(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
                                            unsigned char num_blk, unsigned char *uid, unsigned char  *buffer)
{
    int Retry, StartCnt;

	if(DeviceAddress > MaxAddress)
		return(10);       
	if (num_blk < 0)
		return (1);

    hComm = commHandle;

	for (Retry=0; Retry <MaxTime; Retry++) {
		if (!StartTransmit(DeviceAddress)) {
			if(flags == 0x22) //flagֵжǷҪuidжDATALENGTH
			{ 
				CheckControlCode(0x0B);
			}	//DATALENGTH
			else
			{ 
				CheckControlCode(0x03);
			}	//DATALENGTH

      		CheckControlCode(CMD_ISO15693_Lock);	//CMD
			CheckControlCode(flags);				//FLAG
			CheckControlCode(num_blk);				//ҪĿ
			if (flags == 0x22) {
				for (int n = 0; n < 8; n ++)
					CheckControlCode(uid[n]);
			}
      		
			TransmitData();
   			StartCnt = (WaitReceive + (num_blk >>4)*WaitReceive + 30);  //յʱ䣬ûУ飬⣬У
			
			switch (GetRecData(StartCnt)) {
			case 0:  //check sum success
				if (CheckAddress()==0x00) {
					*buffer = inBuffer[4];
					return(inBuffer[3]);
				}
				else {
					return(5);
				}
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
		else 
			return(3);
	}
	return(4);
}

// 5.RDM_ISO15693_StayQuiet()
extern "C" int RFID_API API_ISO15693_StayQuiet(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
                                                unsigned char *uid,  unsigned char  *buffer )
{
	if (DeviceAddress > MaxAddress)
		return(10);
        
	hComm = commHandle;

	for (int Retry = 0; Retry<MaxTime; Retry++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x0A);
       		CheckControlCode(CMD_ISO15693_StayQuiet);
			CheckControlCode(flags);
			for (int n = 0; n < 8; n ++)
				CheckControlCode(uid[n]);
		
      		TransmitData();
			switch(GetRecData(WaitReceive+200)) {
			case 0:  //check sum success
				if(CheckAddress() == 0x00) {
					*buffer = inBuffer[4];
					return(inBuffer[3]);
				}
				return(5);
			case 1: //check sum error
				return(7);
			} //Eend of switch case decode received data
		}
		else 
			return(3);
	}
	return(4);
}

// 6.API_ISO15693_Select()
extern "C" int RFID_API API_ISO15693_Select(SOCKET commHandle, int DeviceAddress, unsigned char flags,
											unsigned char *uid,  unsigned char  *buffer )
{
	if (DeviceAddress > MaxAddress)
		return(10);
        
	hComm = commHandle;

	for (int Retry = 0; Retry < MaxTime; Retry++)	{
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x0A);
       		CheckControlCode(CMD_ISO15693_Select);
			CheckControlCode(flags);
			for (int n = 0; n < 8; n++)
				CheckControlCode(uid[n]);

      		TransmitData();
			switch(GetRecData(WaitReceive+200)) {
			case 0:  //check sum success
				if(CheckAddress() == 0x00) {
					*buffer = inBuffer[4]; // inBuffer[3] == 0x00 ,*buffer == 0x80
					return(inBuffer[3]);
				}          
				return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
		else 
			return(3);
	}
	return(4);
}

// 7.API_ISO15693_ResetToReady()
extern "C" int RFID_API API_ISO15693_ResetToReady(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
													unsigned char *uid,  unsigned char *buffer )
{
	if(DeviceAddress > MaxAddress)
		return(10);
        
	hComm = commHandle;

	for (int Retry = 0; Retry < MaxTime; Retry++) {
		if (!StartTransmit(DeviceAddress)) {
			if (flags == 0x22) { //FLAGжǷҪUID
				CheckControlCode(0x0A);
			}
			else {  
				CheckControlCode(0x02);
			}
       		CheckControlCode(CMD_ISO15693_Resettoready);
			
			CheckControlCode(flags);
			if (flags == 0x22) {
				for (int n = 0; n < 8; n ++)
					CheckControlCode(uid[n]);
			}
      	
			TransmitData();
			switch (GetRecData(WaitReceive+200)) {
			case 0:  //check sum success
				if (CheckAddress() == 0x00) {
					*buffer = inBuffer[4];
					return(inBuffer[3]);
				}            
				return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
		else 
			return(3);
	}
	return(4);
}

// 8. API_ISO15693_WriteAFI()
extern "C" int RFID_API API_ISO15693_WriteAFI(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
												unsigned char afi, unsigned char *uid, unsigned char *buffer)
{
	if (DeviceAddress > MaxAddress)
		return(10);
        
	hComm = commHandle;

	for (int Retry = 0; Retry < MaxTime; Retry++) {
		if (!StartTransmit(DeviceAddress)) {
			if (flags == 0x22) {  
				CheckControlCode(0x0B);
			}
            else {  
				CheckControlCode(0x03);
			}
      		CheckControlCode(CMD_ISO15693_WriteAfi);
			CheckControlCode(flags);
			CheckControlCode(afi);

			if (flags == 0x22) {
				for (int n = 0; n < 8; n ++)
					CheckControlCode(uid[n]);
			}

			TransmitData();
			switch (GetRecData(WaitReceive + 200)) {
			case 0: //check sum success
				if (CheckAddress() == 0x00) {
					*buffer = inBuffer[4];
					return(inBuffer[3]);
				}
				return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
		else 
			return(3);
	}
	return(4);
}

// 9. API_ISO15693_LockAFI()
extern "C" int RFID_API API_ISO15693_LockAFI(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
												unsigned char *uid, unsigned char *buffer )
{
	if (DeviceAddress > MaxAddress)
		return(10);
        
	hComm = commHandle;

	for (int Retry = 0; Retry < MaxTime; Retry++) {
		if (!StartTransmit(DeviceAddress)) {
			if (flags == 0x22) {  
				CheckControlCode(0x0A);
			}
			else {  
				CheckControlCode(0x02);
			}

       		CheckControlCode(CMD_ISO15693_LockAfi);
			CheckControlCode(flags);

			if (flags==0x22) {
				for (int n = 0; n < 8; n ++)
					CheckControlCode(uid[n]);
			}
      		
			TransmitData();
			switch (GetRecData(WaitReceive+200)) {
			case 0:  //check sum success
				if (CheckAddress() == 0x00) {
					*buffer = inBuffer[4];
					return(inBuffer[3]);
				}            
				return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
		else
			return(3);
	}
	return(4);
}

// 10. API_ISO15693_WriteDSFID()
extern "C" int RFID_API API_ISO15693_WriteDSFID(SOCKET commHandle, int DeviceAddress, unsigned char flags,
												unsigned char DSFID, unsigned char *uid, unsigned char *buffer)
{
	if (DeviceAddress > MaxAddress)
		return(10);
       
	hComm = commHandle;

	for(int Retry = 0; Retry < MaxTime; Retry++) {
		if (!StartTransmit(DeviceAddress)) {
			if (flags == 0x22) {  
				CheckControlCode(0x0B);
			}
            else {  
				CheckControlCode(0x03);
			}

			CheckControlCode(CMD_ISO15693_WriteDsfid);
			CheckControlCode(flags);
			CheckControlCode(DSFID);

			if (flags == 0x22) {
				for (int n = 0; n < 8; n ++)
					CheckControlCode(uid[n]);
			}
      		
			TransmitData();
			switch (GetRecData(WaitReceive + 200)) {
			case 0:  //check sum success
				if (CheckAddress() == 0x00) {
					*buffer = inBuffer[4];
					return(inBuffer[3]);
				}
				return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
		else 
			return(3);
	}
	return(4);
}

// 11.API_ISO15693_LockDSFID()
extern "C" int RFID_API API_ISO15693_LockDSFID(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
												unsigned char *uid, unsigned char *buffer )
{
	if (DeviceAddress > MaxAddress)
		return(10);
        
	hComm = commHandle;

	for (int Retry = 0; Retry < MaxTime; Retry++) {
		if(!StartTransmit(DeviceAddress)) {
			if (flags == 0x22) {  
				CheckControlCode(0x0A);
			}
			else {  
				CheckControlCode(0x02);
			}

       		CheckControlCode(CMD_ISO15693_LockDsfid);
			CheckControlCode(flags);

			if (flags == 0x22) {
				for (int n = 0; n < 8; n ++)
					CheckControlCode(uid[n]);
			}
      	
			TransmitData();
			switch(GetRecData(WaitReceive+200)) {
			case 0:  //check sum success
				if(CheckAddress() == 0x00) {
					*buffer = inBuffer[4];
					return(inBuffer[3]);
				}
				return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
		else 
			return(3);
	}
	return(4);
}

// 12. API_ISO15693_GetSysInfo()
extern "C" int RFID_API API_ISO15693_GetSysInfo(SOCKET commHandle, int deviceAddress,
												unsigned char flag, unsigned char *uid, unsigned char *buffer)
{
    int TimeCount;

    if (deviceAddress > MaxAddress)
		return(10);

    hComm = commHandle;

    for (TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
        if (!StartTransmit(deviceAddress)) {
			if(flag == 0x22) //flagֵжǷҪuidжDATALENGTH
            {
				CheckControlCode(0x0A);
			}	//DATALENGTH
            else
            { 
				CheckControlCode(0x02); 
			}   //DATALENGTH

            CheckControlCode(CMD_ISO15693_GetSysInfo);
            CheckControlCode(flag);

            if(flag == 0x22) { //жϣǷҪUID
				CheckControlCode(uid[0]);
				CheckControlCode(uid[1]);
				CheckControlCode(uid[2]);
				CheckControlCode(uid[3]);
				CheckControlCode(uid[4]);
				CheckControlCode(uid[5]);
				CheckControlCode(uid[6]);
				CheckControlCode(uid[7]);
			}

            TransmitData();
            switch(GetRecData(WaitReceive)) {
			case 0:  //check sum success
				if (!CheckAddress()) {
					if (inBuffer[3] == OK) {
						buffer[0] = inBuffer[2] -1;
						memcpy(&buffer[1], &inBuffer[4], buffer[0]);
					}
					else {
						buffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				} //END the check receive byte counter
				else
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
        else 
			return(3);
    }
    return(4);
}

// 13.API_ISO15693_GetMulSecurity()
extern "C" int RFID_API API_ISO15693_GetMulSecurity(SOCKET commHandle, int deviceAddress, unsigned char flag,
													unsigned char blkAddr, unsigned char blkNum, const unsigned char *uid,
													unsigned char *pBuffer)
{
    if (deviceAddress > MaxAddress)
		return(10);

    hComm = commHandle;

    for (int TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
        if (!StartTransmit(deviceAddress)) {
            if (flag == 0x22) {
				CheckControlCode(0x0C); 
			}
            else {
				CheckControlCode(0x04);  
			}

            CheckControlCode(CMD_ISO15693_GetMulSecurity);
            CheckControlCode(flag);		//FLAG
            CheckControlCode(blkAddr);	//ȡĿַ
            CheckControlCode(blkNum);	//ȡĿ

            if (flag == 0x22) {
				for (int i = 0; i <8; i++)
					CheckControlCode(uid[i]);
            }
            
			TransmitData();
            switch (GetRecData(WaitReceive)) {
			case 0:  //check sum success
				if (!CheckAddress()) {
					if (inBuffer[3] == OK) {
						pBuffer[0] = inBuffer[2] -1;
						memcpy(&pBuffer[1], &inBuffer[4], pBuffer[0]);
					}
					else {
						pBuffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
                return(7);
            } //End of switch case decode received data
        }
		else 
			return(3);
    }
    return(4);
}

// 14.API_ISO15693_TransCmd()
extern "C" int RFID_API API_ISO15693_TransCmd(	SOCKET commHandle, int DeviceAddress, int cmdSize, unsigned char *cmd,
												unsigned char *pbuffer)
{
   	if (DeviceAddress > MaxAddress)
		return(10);
    
	hComm = commHandle;

    for(int TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
            CheckControlCode(cmdSize + 0x02);
            CheckControlCode(CMD_ISO15693_TransferCMD);
            CheckControlCode(cmdSize);

            for (int n = 0; n < cmdSize; n ++) {
				CheckControlCode(cmd[n]);
            }

			TransmitData();
			switch (GetRecData(WaitReceive)) {
			case 0:  //check sum success
				if (!CheckAddress()) {
            		if (inBuffer[3] == OK) {
						pbuffer[0] = inBuffer[2] -1;
						memcpy(&pbuffer[1], &inBuffer[4], pbuffer[0]);
            		}
					else {
						pbuffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else {
					return(5);
				}
			case 1: //check sum error
				return(7);
			} //End of switch case decode received data
		}
		else 
			return(3);
	}
	return(4);
}


/******************************************************* API Mifare Application Function *********************************************************/

// 1.API_MF_Read()
extern "C" int RFID_API API_MF_Read(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char blk_add, 
									unsigned char num_blk, unsigned char *key, unsigned char *Buffer)
{
    int StartCnt;

	if (DeviceAddress > MaxAddress || num_blk <= 0)
		return(10);

	hComm = commHandle;

	for (int Retry = 0; Retry < MaxTime; Retry++) {
		if (!StartTransmit(DeviceAddress)) {
			if (key != NULL) {
				CheckControlCode(0x0A);
      			CheckControlCode(CMD_MF_Read);
				CheckControlCode(mode);		//ȡģʽ
				CheckControlCode(num_blk);	//
				CheckControlCode(blk_add);	//ĵַ
				for (int i = 0; i < 6; i++)
					CheckControlCode(key[i]);
			}
			else {
				CheckControlCode(0x04);
      			CheckControlCode(CMD_MF_Read);
				CheckControlCode(mode);		//ȡģʽ
				CheckControlCode(num_blk);	//
				CheckControlCode(blk_add);	//ĵַ
			}

			TransmitData();

			StartCnt = (WaitReceive + (num_blk >> 4)*WaitReceive +30); //ȴʱļ
			switch (GetRecData(StartCnt)) {
			case 0: //check sum success
				if (CheckAddress()==0x00) {
		    		if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					} else {
						Buffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case deoce recevied data
		}
		else 
			return(3);
	}
	return(4);
}

// 2.API_MF_Write()
extern "C" int RFID_API API_MF_Write(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char blk_add, 
									 unsigned char num_blk, unsigned char *key, unsigned char *senddata, unsigned char *Buffer)
{
    int length, WaitTick;

	if (DeviceAddress > MaxAddress || num_blk > MaxPage || num_blk <= 0x00)
		return(10);

	hComm = commHandle;

	for (int TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			if (key != NULL) {
				length = num_blk * 16;
				CheckControlCode(length +0x0A);
				CheckControlCode(CMD_MF_Write);
				CheckControlCode(mode);
				CheckControlCode(num_blk);
				CheckControlCode(blk_add);
				for (int i = 0; i < 6; i++) {
					CheckControlCode(key[i]);
				}
				for (i = 0; i < length; i++) {
					CheckControlCode(senddata[i]);
				}
			}
			else {
				length = num_blk * 4;
				CheckControlCode(length +0x04);
				CheckControlCode(CMD_MF_Write);
				CheckControlCode(mode);
				CheckControlCode(num_blk);
				CheckControlCode(blk_add);
				for (int i = 0; i < 4; i++) {
					CheckControlCode(senddata[i]);
				}
			}

			TransmitData();

   			WaitTick = (WaitReceive + num_blk*WaitReceive);
			switch (GetRecData(WaitTick)) {
			case 0: //check sum success
				if (!CheckAddress()) {
					if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					}
					else {
						Buffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);   //return status
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case deoce recevied data
		}
		else 
			return(3);
	}
	return(4);
}

// 3.API_MF_InitVal()
extern "C" int RFID_API API_MF_InitVal(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char sec_num, 
									   unsigned char *key, unsigned char *value, unsigned char *Buffer)
{
    int WaitTick;

	if (DeviceAddress > MaxAddress )
		return(10);

	hComm = commHandle;

	for (int TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x0D);
			CheckControlCode(CMD_MF_InitVal);
			CheckControlCode(mode);
			CheckControlCode(sec_num);
			CheckControlCode(key[0]);
			CheckControlCode(key[1]);
			CheckControlCode(key[2]);
			CheckControlCode(key[3]);
			CheckControlCode(key[4]);
			CheckControlCode(key[5]);

  			CheckControlCode(value[0]);
			CheckControlCode(value[1]);
			CheckControlCode(value[2]);
			CheckControlCode(value[3]);

			TransmitData();

   			WaitTick = WaitReceive;
			switch (GetRecData(WaitTick)) {
			case 0: //check sum success
				if (!CheckAddress()) {
					if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					}
					else {
						Buffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case deoce recevied data
		}
		else 
			return(3);
	}
	return(4);
}

// 4.API_MF_Dec();
extern "C" int RFID_API API_MF_Dec(	SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char sec_num,
									unsigned char *key, unsigned char *value, unsigned char *Buffer)
{
    int WaitTick;

	if (DeviceAddress > MaxAddress )
		return(10);

	hComm = commHandle;

	if (!StartTransmit(DeviceAddress)) {
		CheckControlCode(0x0d);
		CheckControlCode(CMD_MF_Dec);
	    CheckControlCode(mode);
	    CheckControlCode(sec_num);
	    CheckControlCode(key[0]);
		CheckControlCode(key[1]);
	    CheckControlCode(key[2]);
		CheckControlCode(key[3]);
	    CheckControlCode(key[4]);
		CheckControlCode(key[5]);
	  	CheckControlCode(value[0]);
		CheckControlCode(value[1]);
	    CheckControlCode(value[2]);
	    CheckControlCode(value[3]);

		TransmitData();

   	    WaitTick = WaitReceive;
		switch (GetRecData(WaitTick)) {
		case 0: //check sum success
			if (!CheckAddress()) {
				if (inBuffer[3] == OK) {
					Buffer[0] = inBuffer[2] -1;
					memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
				}
				else {
					Buffer[0] = inBuffer[4];
				}				
				return(inBuffer[3]);
			}
			else 
				return(5);
		case 1: //check sum error
			return(7);
		} //End of switch case deoce recevied data
	}
	else 
		return(3);
	
	return(4);
}

// 5.API_MF_Inc()
extern "C" int RFID_API API_MF_Inc(	SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char sec_num,
									unsigned char *key, unsigned char *value, unsigned char *Buffer)
{
    int WaitTick;
	
	if (DeviceAddress > MaxAddress )
		return(10);
	
	hComm = commHandle;
	
	if (!StartTransmit(DeviceAddress)) {
		CheckControlCode(0x0d);
		CheckControlCode(CMD_MF_Inc);
		CheckControlCode(mode);
		CheckControlCode(sec_num);
		CheckControlCode(key[0]);
		CheckControlCode(key[1]);
		CheckControlCode(key[2]);
		CheckControlCode(key[3]);
		CheckControlCode(key[4]);
		CheckControlCode(key[5]);
		CheckControlCode(value[0]);
		CheckControlCode(value[1]);
		CheckControlCode(value[2]);
		CheckControlCode(value[3]);
		
		TransmitData();
		
   	    WaitTick = WaitReceive;
		switch (GetRecData(WaitTick)) {
		case 0: //check sum success
			if (!CheckAddress()) {
				if (inBuffer[3] == OK) {
					Buffer[0] = inBuffer[2] -1;
					memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
				}
				else {
					Buffer[0] = inBuffer[4];
				}				
				return(inBuffer[3]);
			}
			else 
				return(5);
		case 1: //check sum error
			return(7);
		} //End of switch case deoce recevied data
	}
	else 
		return(3);
	
	return(4);
}

// 6.API_MF_GET_SNR()
extern "C" int RFID_API API_MF_GET_SNR(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char cmd, unsigned char *Buffer)
{
	if (DeviceAddress > MaxAddress)
		return(10);
	
	hComm = commHandle;
	
	for (int TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x03);
			CheckControlCode(CMD_MF_GET_SNR);
			CheckControlCode(mode);
            CheckControlCode(cmd);

			TransmitData();

			switch (GetRecData(WaitReceive)) {
	         case 0: //check sum success
	       		if (!CheckAddress()) {
					if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					}
					else {
						Buffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case deoce recevied data
		}
		else 
			return(3);
	}
	return(4);
}

/*
// 7.API_MF_Value()
extern "C" int RFID_API API_MF_Value(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char add_blk, int value)
{
	if (DeviceAddress > MaxAddress )
		return(10);

    hComm = commHandle;

	for (int TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x07);
			CheckControlCode(CMD_MF_Value);
			CheckControlCode(mode);
			CheckControlCode(add_blk);
			CheckControlCode((unsigned char)(0xff & value));
			CheckControlCode((unsigned char)(0xff & (value>>8)));
			CheckControlCode((unsigned char)(0xff & (value>>16)));
			CheckControlCode((unsigned char)(0xff & (value>>24)));

			TransmitData();

			switch (GetRecData(WaitReceive)) {
	        case 0: //check sum success
	       		if (!CheckAddress())
					return(inBuffer[3]);
				else
					return(5);
			case 1: //check sum error
				return(7);
			} //End of switch case deoce recevied data
		}
		else 
			return(3);
	}
	return(4);
}
*/

// 8.API_MF_PowerOn()
extern "C" int RFID_API API_MF_PowerOn(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char cmd, unsigned char *Buffer)
{
	if (DeviceAddress > MaxAddress)
		return(10);

	hComm = commHandle;
		 
	for (int TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x03);
			CheckControlCode(CMD_MF_PowerOn);
			CheckControlCode(mode);
			CheckControlCode(cmd);

			TransmitData();

			switch(GetRecData(WaitReceive)) {
	        case 0: //check sum success
				if (!CheckAddress()) {
					if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					}
					else {
						Buffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else
					return(5);
			case 1: //check sum error
				return(7);
			}
		}
		else return(3);
	}
	return(4);
}

// 9.API_MF_TransferCMD()
extern "C" int RFID_API API_MF_TransferCMD(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char cmdlength,
										   unsigned char *cmd, unsigned char *Buffer)
{
	if (DeviceAddress > MaxAddress )
		return(10);

	hComm = commHandle;

	for (int TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(cmdlength + 0x03);
			CheckControlCode(CMD_MF_Transfer);
			CheckControlCode(mode);
           	CheckControlCode(cmdlength);
            for (int i = 0; i < cmdlength; i++) {
				CheckControlCode(*(cmd+i));
			}

			TransmitData();

			switch (GetRecData(WaitReceive)) {
			case 0: //check sum success
				if (!CheckAddress()) {
					if (inBuffer[3] == OK) {
						Buffer[0] = inBuffer[2] -1;
						memcpy(&Buffer[1], &inBuffer[4], Buffer[0]);
					}
					else {
						Buffer[0] = inBuffer[4];
					}
					return(inBuffer[3]);
				}
				else 
					return(5);
			case 1: //check sum error
				return(7);
			}
		}
		else
			return(3);
	}
	return(4);
}

// 10.API_MF_RST_Antenna()
extern "C" int RFID_API API_MF_RST_Antenna(SOCKET commHandle, int DeviceAddress, unsigned char *Buffer)
{
	if (DeviceAddress > MaxAddress )
		return(10);

	hComm = commHandle;

	for (int TimeCount = 0; TimeCount < MaxTime; TimeCount++) {
		if (!StartTransmit(DeviceAddress)) {
			CheckControlCode(0x01);
			CheckControlCode(CMD_MF_RST_Antenna);

			TransmitData();

			switch (GetRecData(WaitReceive +10)) {
	        case 0: //check sum success
	       		if (!CheckAddress()) {
	       			Buffer[0] = inBuffer[4];
					return(inBuffer[3]);
	       		}
				else {
					return(5);
				}
			case 1: //check sum error
				return(7);
			}
		}
		else 
			return(3);
	}
	return(4);
}